<?php
// no direct access
defined('ABSPATH') || die();

/** @var LSD_PTypes_Shortcode $this */
/** @var WP_Post $post */

// Sorts
$sorts = get_post_meta($post->ID, 'lsd_sorts', true);

// Apply default values
if (!is_array($sorts) || !count($sorts)) $sorts = LSD_Options::defaults('sorts');

// Available Options
$base_options = $this->get_available_sort_options();

if (!isset($sorts['options'])) $options = $base_options;
else
{
    $options = $sorts['options'];
    foreach ($base_options as $k=>$b) if (!isset($options[$k])) $options[$k] = $b;
}
?>
<div id="lsd_metabox_sort_options" class="lsd-metabox lsd-metabox-sort-options">
    <div class="lsd-settings-group-wrapper">
        <div class="lsd-settings-fields-wrapper">
            <div class="lsd-admin-section-heading">
                <h3 class="lsd-my-0 lsd-admin-title"><?php echo esc_html__("Style", 'listdom'); ?></h3>
                <p class="lsd-admin-description lsd-m-0"><?php echo esc_html__("Enable the sort for this shortcode and select the style of it.", 'listdom'); ?> </p>
            </div>

            <div class="lsd-form-row lsd-flex-align-items-center">
                <label class="lsd-col-3 lsd-fields-label" for="lsd_sort_options_status"><?php esc_html_e('Display Sort Options', 'listdom'); ?></label>
                <div class="lsd-col-7">
                    <?php echo LSD_Form::switcher([
                        'id' => 'lsd_sort_options_status',
                        'toggle' => '.lsd_sort_options_toggle',
                        'name' => 'lsd[sorts][display]',
                        'value' => $sorts['display'] ?? '1'
                    ]); ?>
                </div>
            </div>

            <div class="lsd_sort_options_toggle <?php echo isset($sorts['display']) && $sorts['display'] ? '' : 'lsd-util-hide'; ?>">
                <div class="lsd-metabox-sort-options-default-style lsd-form-row">
                    <label class="lsd-col-3 lsd-fields-label" for="lsd_sort_options_style"><?php esc_html_e('Sort Style', 'listdom'); ?></label>
                    <select class="lsd-col-7 lsd-admin-input" name="lsd[sorts][sort_style]" id="lsd_sort_options_style">
                        <option value=""><?php esc_html_e('Default Style', 'listdom'); ?></option>
                        <option value="drop-down" <?php echo isset($sorts['sort_style']) && $sorts['sort_style'] === 'drop-down' ? 'selected="selected"' : ''; ?>><?php esc_html_e('Drop Down', 'listdom'); ?></option>
                        <option value="list" <?php echo isset($sorts['sort_style']) && $sorts['sort_style'] === 'list' ? 'selected="selected"' : ''; ?>><?php esc_html_e('List', 'listdom'); ?></option>
                    </select>
                </div>
            </div>
        </div>

        <div class="lsd_sort_options_toggle <?php echo isset($sorts['display']) && $sorts['display'] ? '' : 'lsd-util-hide'; ?>">

            <div class="lsd-settings-fields-wrapper">
                <div class="lsd-admin-section-heading">
                    <h3 class="lsd-my-0 lsd-admin-title"><?php echo esc_html__("Sort Options", 'listdom'); ?></h3>
                    <p class="lsd-admin-description lsd-m-0"><?php echo esc_html__("Enable and configure the sort options.", 'listdom'); ?> </p>
                </div>
                <div class="lsd-sortable lsd-flex lsd-flex-col lsd-gap-4 lsd-flex-align-items-start">
                    <?php foreach ($options as $key=>$option): ?>
                        <?php
                        $base = $base_options[$key] ?? [];
                        if (!count($base)) continue;

                        $status = $option['status'] ?? $base['status'];
                        ?>
                        <div class="lsd-metabox-sort-option <?php echo $status ? '': 'lsd-metabox-sort-option-disable'; ?>" id="lsd-sort-options-<?php echo esc_attr($key); ?>">
                            <div class="lsd-metabox-sort-option-head">
                                <div class="lsd-metabox-sort-option-handle">
                                    <div class="lsd-cursor-move lsd-text-left">
                                        <i class="lsd-icon fas fa-arrows-alt"></i>
                                    </div>
                                    <?php if (isset($base['name'])): ?>
                                        <strong><?php echo esc_html($base['name']); ?></strong>
                                    <?php endif; ?>
                                </div>
                                <div class="lsd-col-2 lsd-cursor-pointer lsd-p-0 lsd-text-right lsd-sort-option-toggle" data-key="<?php echo esc_attr($key); ?>">
                                    <i class="lsd-icon fa fa-<?php echo $status ? 'check-circle' : 'minus-circle'; ?>"></i>
                                </div>
                            </div>
                            <div class="lsd-form-row">
                                <div class="lsd-col-12 lsd-metabox-sort-options-inputs">
                                    <input type="hidden" name="lsd[sorts][options][<?php echo esc_attr($key); ?>][status]" value="<?php echo esc_attr($status); ?>" id="lsd-sort-options-<?php echo esc_attr($key); ?>-status">
                                    <input class="lsd-admin-input" type="text" name="lsd[sorts][options][<?php echo esc_attr($key); ?>][name]" placeholder="<?php esc_attr_e('Name', 'listdom'); ?>" title="<?php esc_attr_e('Name', 'listdom'); ?>" value="<?php echo $option['name'] ?? ($base['name'] ?? ''); ?>" <?php echo $status ? '' : 'disabled="disabled"'; ?>>
                                    <select class="lsd-admin-input" name="lsd[sorts][options][<?php echo esc_attr($key); ?>][order]" title="<?php esc_attr_e('Default Order', 'listdom'); ?>" <?php echo ($status ? '' : 'disabled="disabled"'); ?>>
                                        <option value="DESC" <?php echo ($option['order'] ?? ($base['order'] ?? '')) == 'DESC' ? 'selected="selected"' : ''; ?>><?php echo esc_html__('Descending', 'listdom'); ?></option>
                                        <option value="ASC" <?php echo ($option['order'] ?? ($base['order'] ?? '')) == 'ASC' ? 'selected="selected"' : ''; ?>><?php echo esc_html__('Ascending', 'listdom'); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</div>
