<?php
// no direct access
defined('ABSPATH') || die();

/** @var string $redirect */
/** @var string $role */

// User is Already Logged-in
if (is_user_logged_in()) return '';

$auth = LSD_Options::auth();

if (!trim($redirect))
{
    $redirect = isset($auth['login']['redirect']) && $auth['login']['redirect']
        ? get_permalink($auth['login']['redirect'])
        : home_url();
}

$verification_notice = '';
$verification_notice_class = 'lsd-success';
if (isset($_GET['lsd-verified']))
{
    $verified_status = sanitize_text_field(wp_unslash($_GET['lsd-verified']));

    if ($verified_status === '1')
    {
        $verification_notice = LSD_User::verification_success_message();
        $verification_notice_class = 'lsd-success';
    }
    else
    {
        $verification_notice = LSD_User::verification_failed_message();
        $verification_notice_class = 'lsd-error';
    }
}

$username_label = $auth['login']['username_label'];
$username_placeholder = $auth['login']['username_placeholder'];
$password_label = $auth['login']['password_label'];
$password_placeholder = $auth['login']['password_placeholder'];
$remember_label = $auth['login']['remember_label'];
$login_submit_label = $auth['login']['submit_label'];

$assets = new LSD_Assets();
$assets->footer('<script>
jQuery(document).ready(function()
{
    jQuery("#lsd-login").listdomLoginForm(
    {
        ajax_url: "' . admin_url('admin-ajax.php') . '",
        nonce: "' . wp_create_nonce('lsd_login') . '"
    });
    
    // Adding placeholders via jQuery
    jQuery("#lsd-login #user_login").attr("placeholder", "' . esc_js($username_placeholder) . '");
    jQuery("#lsd-login #user_pass").attr("placeholder", "' . esc_js($password_placeholder) . '");
});
</script>');
?>
<div class="lsd-login-wrapper">
    <?php if (trim($verification_notice)): ?>
        <div class="lsd-alert <?php echo esc_attr($verification_notice_class); ?>"><?php echo esc_html($verification_notice); ?></div>
    <?php endif; ?>
    <div id="lsd_login_form_message"></div>
    <form id="lsd-login" method="post">
        <div class="login-form-content">
            <?php wp_login_form([
                'redirect' => $redirect,
                'form_id' => 'lsd-login',
                'label_username' => $username_label,
                'label_password' => $password_label,
                'label_remember' => $remember_label,
                'label_log_in' => $login_submit_label,
                'remember' => true,
                'placeholder_username' => $username_placeholder,
                'placeholder_password' => $password_placeholder,
                'id_submit' => 'lsd-auth-login-submit',
            ]); ?>
            <?php LSD_Form::nonce('lsd_login','lsd_login'); ?>
            <?php if (trim($role)) echo LSD_Form::hidden([
                'name' => 'lsd_role',
                'id' => 'lsd_role',
                'value' => $role,
            ]); ?>
        </div>
    </form>
</div>
