<?php
// no direct access
defined('ABSPATH') || die();

/** @var int $order_id */
/** @var string $date */
/** @var string $email */
/** @var string $total */
/** @var string $payment_method */
/** @var bool $show_invoice_button */
/** @var string $invoice_url */
/** @var string $style */
?>
<div class="lsd-order-summary-wrapper">
    <div class="lsd-order-summary-icon">
        <i class="lsd-fe-icon fa fa-check-circle"></i>
        <h2 class="lsd-fe-title"><?php esc_html_e('Thanks for your order', 'listdom'); ?></h2>
    </div>

    <ul class="lsd-order-summary <?php echo $style === 'list' ? 'lsd-order-summary-list' : 'lsd-order-summary-inline'; ?>">
        <li>
            <span class="lsd-label"><?php esc_html_e('Order Number', 'listdom'); ?>:</span>
            <span class="lsd-value"><?php echo esc_html($order_id); ?></span>
        </li>
        <li>
            <span class="lsd-label"><?php esc_html_e('Date', 'listdom'); ?>:</span>
            <span class="lsd-value"><?php echo esc_html($date); ?></span>
        </li>
        <li>
            <span class="lsd-label"><?php esc_html_e('Email', 'listdom'); ?>:</span>
            <span class="lsd-value"><?php echo esc_html($email); ?></span>
        </li>
        <li>
            <span class="lsd-label"><?php esc_html_e('Payment Method', 'listdom'); ?>:</span>
            <span class="lsd-value"><?php echo esc_html($payment_method); ?></span>
        </li>
        <li class="<?php echo $style === 'list' ? '': 'lsd-util-hide'; ?>">
            <div class="lsd-fe-divider"></div>
        </li>
        <li>
            <span class="lsd-label"><?php esc_html_e('Total', 'listdom'); ?>:</span>
            <span class="lsd-value"><?php echo LSD_Kses::element($total); ?></span>
        </li>
    </ul>

    <?php if ($show_invoice_button && $invoice_url): ?>
        <a class="lsd-light-button" href="<?php echo esc_url($invoice_url); ?>" target="_blank" rel="noopener noreferrer">
            <i class="lsd-fe-icon fa fa-file-pdf"></i>
            <?php esc_html_e('Download Invoice', 'listdom'); ?>
        </a>
    <?php endif; ?>
</div>
