<?php
// no direct access
defined('ABSPATH') || die();

/** @var LSD_Cart $cart */
/** @var LSD_Main $main */
/** @var string $currency */
/** @var string $coupon_code */
/** @var array $fees */

[$total, $discount] = $cart->apply_coupon();
$coupon = $coupon_code ? new LSD_Payments_Coupon($coupon_code) : null;

$tooltip = '';
if ($discount > 0 && $coupon)
{
    $parts = [];
    if ($coupon->get_discount() > 0) $parts[] = sprintf(__('%s%%', 'listdom'), $coupon->get_discount());
    if ($coupon->get_deduction() > 0) $parts[] = $main->render_price($coupon->get_deduction(), $currency);

    if ($coupon_code) $tooltip .= sprintf(__('Code: %s', 'listdom'), $coupon_code);
    if ($parts) $tooltip .= "\n" . sprintf(__('Amount: %s', 'listdom'), implode(' + ', $parts));

    $tooltip = strip_tags($tooltip);
}
?>
<div class="lsd-cart-summary">
    <div class="lsd-cart-summary-row">
        <span class="lsd-label"><?php esc_html_e('Subtotal:', 'listdom'); ?></span>
        <span class="lsd-value">
            <?php echo LSD_Kses::element($main->render_price($cart->get_sub_total(), $currency)); ?>
        </span>
    </div>

    <?php if ($discount > 0): ?>
        <div class="lsd-cart-summary-row lsd-cart-discount">
            <span class="lsd-label">
                <?php esc_html_e('Discount:', 'listdom'); ?>
                <?php if ($tooltip): ?>
                    <span class="lsd-tooltip lsd-fe-tooltip" data-lsd-tooltip="<?php echo esc_attr($tooltip); ?>">
                        <i class="fa fa-question-circle lsd-fe-icon"></i>
                    </span>
                <?php endif; ?>
            </span>
            <span class="lsd-value">-<?php echo LSD_Kses::element($main->render_price($discount, $currency)); ?></span>
        </div>
    <?php endif; ?>

    <div class="lsd-fe-divider"></div>

    <div class="lsd-cart-summary-row lsd-cart-total">
        <span class="lsd-label"><?php esc_html_e('Total:', 'listdom'); ?></span>
        <span class="lsd-value"><?php echo LSD_Kses::element($main->render_price($total, $currency)); ?></span>
    </div>
</div>
