<?php

class LSDR_Jetpack extends LSDR_Base
{
    public function init()
    {
        add_action('after_setup_theme', [$this, 'setup']);
    }

    public function setup()
    {
        // Add theme support for Infinite Scroll.
        add_theme_support('infinite-scroll', [
            'container' => 'main',
            'render' => [$this, 'render'],
            'footer' => 'page',
        ]);

        // Add theme support for Responsive Videos.
        add_theme_support('jetpack-responsive-videos');

        // Add theme support for Content Options.
        add_theme_support('jetpack-content-options', [
            'post-details' => [
                'stylesheet' => 'listdomer',
                'date' => '.posted-on',
                'categories' => '.cat-links',
                'tags' => '.tags-links',
                'author' => '.byline',
                'comment' => '.comments-link',
            ],
            'featured-images' => [
                'archive' => true,
                'post' => true,
                'page' => true,
            ],
        ]);
    }

    public function render()
    {
        while (have_posts())
        {
            the_post();

            if (is_search()) get_template_part('partials/content', 'search');
            else get_template_part('partials/content', get_post_type());
        }
    }
}
